@extends('layouts.master')
@section('title','Advertise Setting')
@section('breadcum')
	<div class="breadcrumbbar">
    <h4 class="page-title">{{ __('Advertise Setting') }}</h4>
    <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
          <li class="breadcrumb-item active" aria-current="page">{{ __('Advertise Setting') }}</li>
        </ol>
    </div>  
  </div>
@endsection
@section('maincontent')
<div class="contentbar ads-setting-block">
	<div class="row">
		<div class="col-lg-12">
      <!-- Nav tabs -->
      <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="active"><a href="#home1" aria-controls="home1" role="tab" data-toggle="tab">{{__('Advertise Setting')}}</a></li>
        <li role="presentation"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Skip AD Setting</a></li>
        <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">Pop Up Ad Setting</a></li>
      </ul>
      <!-- Tab panes -->
      <div class="tab-content">
        <div role="tabpanel" class="tab-pane fade show active" id="home1">
          {!! Form::model($button, ['method' => 'PUT', 'route' => ['ad.toggle'], 'files' => true]) !!}
          {!! Form::hidden('id', $button->id) !!}
          <div class="col-md-3">
              <div class="custom_toggle-checkbox form-group{{ $errors->has('remove_ads') ? ' has-error' : '' }}">
                  <label class="text-dark">{{ __('Remove Ads') }} :</label><br>
                  {!! Form::checkbox('remove_ads', 1, $button->remove_ads, ['class' => 'custom_toggle']) !!}
                  @if($errors->has('remove_ads'))
                      <small class="text-danger">{{ $errors->first('remove_ads') }}</small>
                  @endif
              </div>
          </div>
          <button type="submit" class="btn btn-md btn-success">{{ __('Save') }}</button>
          {!! Form::close() !!}
          
        
        </div>
        
        <div role="tabpanel" class="fade tab-pane" id="home">
          <form action="{{ route('ad.update') }}" method="POST">
            {{ csrf_field() }}
            {{ method_field('PUT') }}
            <label for="">Skip AD Timer</label>
            <select name="timer_check" id="timer" class="form-control">
              <option value="no">No</option>
              <option value="yes">Yes</option>
            </select>
          <br>
          <div style="display: none;" id="t">
            <div class="row">
              <div class="col-lg-6">
                <div class="form-group">
                  <label for="time">Time : ( Please Ensure that its not conflict with popup ad start time )</label>
                  <input type="text" placeholder="00:00:10" name="ad_timer" class="form-control">
                </div>
              </div>
              <div class="col-lg-6">
                <div class="form-group">
                  <label for="">Ad Hold Time: </label>
                  <input type="number" name="ad_hold" min="0" max="10" placeholder="eg. 5" class="form-control">
                </div>
              </div>
            </div>        
          </div>
          <input type="submit" value="Save" class="btn btn-md btn-success">
          </form>
        </div>

        <div role="tabpanel" class="fade tab-pane" id="profile">
          
            <form action="{{ route('ad.pop.update') }}" method="POST">
            {{ csrf_field() }}
            {{ method_field('PUT') }}
            <div class="row">
              <div class="col-lg-6">
                <div class="form-group">
                  <label for="">Start Time: <span class="help-block">( Please Ensure that its not conflict with video ad start time )</span></label>
                  <input type="text" name="time" placeholder="00:00:10" class="form-control">
                </div>
              </div>
              <div class="col-lg-6">
                <label for="">End Time: </label>
                <input type="text" name="endtime" placeholder="00:00:30" class="form-control">
              </div>
            </div>
            <input type="submit" value="Save" class="btn btn-md btn-success">
          </form>
        </div>

    
          
      </div>

    </div>
		</div>
	</div>
</div>


  
  
@endsection
@section('script')
  <script type="text/javascript">
    $('#timer').change(function(){
      if($(this).val() == 'no')
      {
        $('#t').hide();
      }else
      {
        $('#t').show();
      }
    });
  </script>
@endsection